unit UJavaIDE;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ToolWin, Menus, StdCtrls, ClipBrd;

type
  TfrmJAVAIDE = class(TForm)
    tbrBarre: TToolBar;
    tbtOuvrir: TToolButton;
    MainMenu1: TMainMenu;
    mnuFichier: TMenuItem;
    mnuOuvrir: TMenuItem;
    mnuEnregistrer: TMenuItem;
    mnuEnregistrersous: TMenuItem;
    N1: TMenuItem;
    mnuQuitter: TMenuItem;
    ImageList1: TImageList;
    stbEtat: TStatusBar;
    odlOuvrir: TOpenDialog;
    sdlEnreg: TSaveDialog;
    mnuNouveau: TMenuItem;
    mnuJava: TMenuItem;
    mnuCompiler: TMenuItem;
    mnuExecuter: TMenuItem;
    mnuCompExec: TMenuItem;
    N2: TMenuItem;
    mnuOptions: TMenuItem;
    tbtNouveau: TToolButton;
    tbtEnreg: TToolButton;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    tbtCopier: TToolButton;
    tbtCouper: TToolButton;
    tbtColler: TToolButton;
    ToolButton6: TToolButton;
    tbtAnnuler: TToolButton;
    mnuEdition: TMenuItem;
    mnuCopier: TMenuItem;
    mnuColler: TMenuItem;
    mnuCouper: TMenuItem;
    N3: TMenuItem;
    mnuAnnuler: TMenuItem;
    tbtCompiler: TToolButton;
    tbtExecuter: TToolButton;
    tbtCompExec: TToolButton;
    N4: TMenuItem;
    mnuPolice: TMenuItem;
    fdlPolice: TFontDialog;
    memEdition: TMemo;
    tbtJavadoc: TToolButton;
    ToolButton4: TToolButton;
    mnuJavadoc: TMenuItem;
    procedure FormResize(Sender: TObject);
    procedure mnuQuitterClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure mnuOuvrirClick(Sender: TObject);
    procedure tbtOuvrirClick(Sender: TObject);
    procedure mnuNouveauClick(Sender: TObject);
    procedure memEditionChange(Sender: TObject);
    procedure tbtNouveauClick(Sender: TObject);
    procedure mnuEnregistrerClick(Sender: TObject);
    procedure tbtEnregClick(Sender: TObject);
    procedure mnuEnregistrersousClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure mnuOptionsClick(Sender: TObject);
    procedure memEditionSaveClipboard(Sender: TObject; NumObjects,
      NumChars: Integer; var SaveClipboard: Boolean);
    procedure memEditionKeyPress(Sender: TObject; var Key: Char);
    procedure tbtCopierClick(Sender: TObject);
    procedure tbtCouperClick(Sender: TObject);
    procedure tbtCollerClick(Sender: TObject);
    procedure tbtAnnulerClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure MAJCurseur;
    procedure memEditionMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure memEditionKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure mnuAnnulerClick(Sender: TObject);
    procedure mnuCopierClick(Sender: TObject);
    procedure mnuCouperClick(Sender: TObject);
    procedure mnuCollerClick(Sender: TObject);
    procedure memEditionMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormActivate(Sender: TObject);
    procedure mnuCompilerClick(Sender: TObject);
    procedure mnuExecuterClick(Sender: TObject);
    procedure mnuCompExecClick(Sender: TObject);
    procedure tbtCompilerClick(Sender: TObject);
    procedure tbtExecuterClick(Sender: TObject);
    procedure tbtCompExecClick(Sender: TObject);
    procedure MAJBoutons;
    procedure fdlPoliceApply(Sender: TObject; Wnd: Integer);
    procedure mnuPoliceClick(Sender: TObject);
    procedure mnuJavadocClick(Sender: TObject);
    procedure tbtJavadocClick(Sender: TObject);
    procedure memEditionKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Dclarations prives }
    FClipboardOwner: HWnd;
    FicAct : string;
    procedure ClipboardChanged;
  public
    { Dclarations publiques }
    procedure AfficheHint(Sender: TObject);
    procedure WMChangeCBChain(var Msg: TWMChangeCBChain); message WM_CHANGECBCHAIN;
    procedure WMDrawClipboard(var Msg: TWMDrawClipboard); message WM_DRAWCLIPBOARD;
  end;

var
  frmJAVAIDE: TfrmJAVAIDE;

implementation

uses Uoptions, Richedit, INifiles, shellApI, USortie;

{$R *.DFM}

procedure TfrmJAVAIDE.FormResize(Sender: TObject);
begin
  stbEtat.Panels[0].width:=frmJavaide.width-80;
  MAjCurseur;
end;

procedure TfrmJAVAIDE.mnuQuitterClick(Sender: TObject);
begin
  frmJavaIDE.close;
end;

procedure TfrmJAVAIDE.FormCreate(Sender: TObject);
begin
  application.onHint := AfficheHint;
  FClipboardOwner := SetClipboardViewer(Handle);
  MAJCurseur;
  FicAct := '';
end;

procedure TfrmJAVAIDE.AfficheHint(Sender : TObject);
begin
  stbEtat.Panels[0].text := GetLongHint(Application.Hint);
end;

procedure TfrmJAVAIDE.mnuOuvrirClick(Sender: TObject);
begin
  if odlOuvrir.execute then begin
    memEdition.lines.loadfromfile(odlOuvrir.filename);
    memEdition.tag:=0;
    FicAct :=odlOuvrir.filename;
    Caption := 'Java IDE - '+extractfilename(ficact);
  end;
  MAJBoutons;
end;

procedure TfrmJAVAIDE.tbtOuvrirClick(Sender: TObject);
begin
  mnuOuvrirClick(Sender);
end;

procedure TfrmJAVAIDE.mnuNouveauClick(Sender: TObject);
begin
  if memEdition.tag = 1 then begin
    case application.messagebox('Le fichier n''a pas t enregistr.'+#13+'Voulez-vous le faire maintenant ?','Nouveau fichier',MB_YESNOCANCEL + MB_ICONQUESTION) of
      ID_YES : mnuEnregistrerClick(Sender);
      ID_NO : ;
      ID_CANCEL : exit;
    end;
  end;
  memEdition.lines.clear;
  memEdition.tag:=0;
  Caption := 'Java IDE - [Nouveau fichier]';
  MAJBoutons;
end;

procedure TfrmJAVAIDE.memEditionChange(Sender: TObject);
begin
  memEdition.tag:=1;
  MAJCurseur;
  tbtAnnuler.Enabled := SendMessage(memEdition.Handle, EM_CANUNDO, 0, 0) <> 0;
  mnuAnnuler.enabled:=tbtAnnuler.enabled;
end;

{procedure TfrmJAVAIDE.memEditionChange(Sender: TObject);
begin
  memEdition.tag:=1;
  MAJCurseur;
  tbtAnnuler.Enabled := SendMessage(memEdition.Handle, EM_CANUNDO, 0, 0) <> 0;
  mnuAnnuler.enabled:=tbtAnnuler.enabled;
end;}

procedure TfrmJAVAIDE.tbtNouveauClick(Sender: TObject);
begin
  mnuNouveauClick(Sender);
end;

procedure TfrmJAVAIDE.mnuEnregistrerClick(Sender: TObject);
begin
  if FicAct<>'' then
    memEdition.lines.savetofile(FicAct)
  else
    mnuEnregistrerSousClick(Sender);
  memEdition.tag := 0;
end;

procedure TfrmJAVAIDE.tbtEnregClick(Sender: TObject);
begin
  mnuEnregistrerClick(Sender);
end;

procedure TfrmJAVAIDE.mnuEnregistrersousClick(Sender: TObject);
begin
  if sdlEnreg.execute then begin
    memEdition.Lines.savetofile(sdlEnreg.filename);
    memEdition.tag:=0;
    FicAct := sdlEnreg.filename;
    Caption := 'Java IDE - '+extractfilename(ficact);
  end;
  MAJBoutons;
end;

procedure TfrmJAVAIDE.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  if memEdition.tag=0 then begin
    if application.messagebox('Etes-vous sr(e) de vouloir quitter ?', 'Quitter', MB_YESNO+MB_ICONQUESTION+MB_DEFBUTTON2)=ID_YES then
      canclose := true
    else
      canclose := false;
  end
  else begin
    case application.messagebox('Vous n''avez pas enregistr votre fichier.'+#13+'Voulez-vous le faire maintenant ?', 'Quitter', MB_YESNOCANCEL+MB_ICONQUESTION) of
      ID_YES : begin
                 mnuEnregistrerClick(Sender);
                 canclose := true;
               end;
      ID_NO : canclose := true;
      ID_CANCEL : canclose := false;
    end
  end;
end;

procedure TfrmJAVAIDE.mnuOptionsClick(Sender: TObject);
var fic : TIniFile;
begin
  frmOptions.showmodal;
  fic := TInifile.create( extractfilepath(application.exename)+'\cfg.ini');
  with fic do begin
    writestring('Applications','Javac',frmOptions.lblRepJavac.caption);
    writestring('Applications','Java',frmOptions.lblRepJava.caption);
    writestring('Rpertoires','Classes',frmOptions.edtClasses.text);
    free;
  end;
  MAJBoutons;
{  mnuCompiler.enabled := (copy(frmOptions.lblrepjavac.caption,1,1)<>'[');
  mnuExecuter.enabled := (copy(frmOptions.lblrepjava.caption,1,1)<>'[');
  mnuCompExec.enabled := mnuCompiler.enabled and mnuExecuter.enabled;
}
end;

procedure TfrmJAVAIDE.memEditionSaveClipboard(Sender: TObject; NumObjects,
  NumChars: Integer; var SaveClipboard: Boolean);
begin
  saveclipboard := false;
end;

procedure TfrmJAVAIDE.memEditionKeyPress(Sender: TObject; var Key: Char);
begin
  MAJCurseur;
end;

procedure TfrmJAVAIDE.tbtCopierClick(Sender: TObject);
begin
  memEdition.CopyToClipboard;
end;

procedure TfrmJAVAIDE.tbtCouperClick(Sender: TObject);
begin
  memEdition.CutToClipboard;
end;

procedure TfrmJAVAIDE.tbtCollerClick(Sender: TObject);
begin
  memEdition.PasteFromClipboard;
end;

procedure TfrmJAVAIDE.tbtAnnulerClick(Sender: TObject);
begin
  with memEdition do
    if HandleAllocated then SendMessage(Handle, EM_UNDO, 0, 0);
end;

procedure TfrmJAVAIDE.FormShow(Sender: TObject);
begin
  MAJCurseur;
end;

procedure TfrmJavaIDE.MAJCurseur();
var x, y : integer ;
begin
  Y := SendMessage(memEdition.Handle, EM_LINEFROMCHAR, -1, 0);
  X := (memEdition.SelStart - SendMessage(memEdition.Handle, EM_LINEINDEX, Y, 0));
  stbEtat.Panels[1].Text := Format('%3d : %3d', [Y+1, X+1]);
  
  if memEdition.sellength > 0 then begin
    tbtCopier.enabled:=true;
    tbtCouper.enabled:=true;
  end
  else begin
    tbtCopier.enabled:=false;
    tbtCouper.enabled:=false;
  end;
  mnuCopier.enabled:=tbtCopier.enabled;
  mnuCouper.enabled:=tbtCouper.enabled;
end;

procedure TfrmJAVAIDE.memEditionMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  MAJCurseur;
end;

procedure TfrmJavaIDE.ClipboardChanged;
begin
  if clipboard.hasformat(CF_TEXT) then
    tbtColler.Enabled := true
  else
    tbtColler.Enabled := false;
  mnuColler.enabled:=tbtColler.enabled;
end;

procedure TfrmJavaIde.WMDrawClipboard(var Msg: TWMDrawClipboard);
begin
  SendMessage(FClipboardOwner, WM_DRAWCLIPBOARD, 0, 0);
  Msg.Result := 0;
  ClipboardChanged;
end;

procedure TfrmJavaIde.WMChangeCBChain(var Msg: TWMChangeCBChain);
begin
  if Msg.Remove = FClipboardOwner then FClipboardOwner := Msg.Next
  else SendMessage(FClipboardOwner, WM_CHANGECBCHAIN, Msg.Remove, Msg.Next);
  Msg.Result := 0;
end;

procedure TfrmJAVAIDE.memEditionKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  MAJCurseur;
end;

procedure TfrmJAVAIDE.mnuAnnulerClick(Sender: TObject);
begin
  tbtAnnulerClick(Sender);
end;

procedure TfrmJAVAIDE.mnuCopierClick(Sender: TObject);
begin
  tbtCopierClick(Sender);
end;

procedure TfrmJAVAIDE.mnuCouperClick(Sender: TObject);
begin
  tbtCouperClick(Sender);
end;

procedure TfrmJAVAIDE.mnuCollerClick(Sender: TObject);
begin
  tbtCollerClick(Sender);
end;

procedure TfrmJAVAIDE.memEditionMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  MAJCurseur;
end;

procedure TfrmJAVAIDE.FormActivate(Sender: TObject);
var fic : TIniFile;
begin
  fic := TInifile.create( extractfilepath(application.exename)+'\cfg.ini');
  with fic do begin
    frmOptions.lblRepJavac.caption:=readstring('Applications','Javac','[Non spcifi]');
    frmOptions.lblRepJava.caption:=readstring('Applications','Java','[Non spcifi]');
    frmOptions.edtClasses.text:=readstring('Rpertoires','Classes','');
    if not fileexists(frmOptions.lblRepJavac.caption+'\java.exe') then begin
      frmOptions.lblRepJavac.caption := '[Non spcifi]';
      writestring('Applications','Javac',frmOptions.lblRepJavac.caption);
    end;
    if not fileexists(frmOptions.lblRepJava.caption+'\java.exe') then begin
      frmOptions.lblRepJava.caption := '[Non spcifi]';
      writestring('Applications','Java',frmOptions.lblRepJava.caption);
    end;
    free;
  end;
  MAJBoutons;
end;

procedure TfrmJAVAIDE.mnuCompilerClick(Sender: TObject);
begin
  tbtCompilerClick(Sender);
end;

procedure TfrmJAVAIDE.mnuExecuterClick(Sender: TObject);
begin
  tbtExecuterClick(Sender);
end;

procedure TfrmJAVAIDE.mnuCompExecClick(Sender: TObject);
begin
  tbtCompExecClick(Sender);
end;

procedure TfrmJAVAIDE.tbtCompilerClick(Sender: TObject);
type tab = array [0..2000] of char;
var nomfic, rep : PChar;
    StartupInfo: TStartupInfo;
    ProcessInfo: TProcessInformation;
    Buffer : ^tab;
    taille, debut : TCoord;
    region : TSmallRect;
begin
  if FicAct<>'' then begin
    getmem(nomfic, 255);
    getmem(rep, 255);

    frmsortie.show;
    FillChar (StartupInfo, SizeOf(StartupInfo), #0);
    StartupInfo.cb := SizeOf(StartupInfo);
    StartupInfo.dwFlags := STARTF_USESHOWWINDOW or STARTF_USESTDHANDLES or STARTF_USEFILLATTRIBUTE;
    StartupInfo.wShowWindow := SW_SHOWNORMAL;
    StartupInfo.lpTitle := StrPcopy(rep, '');
    StartupInfo.dwfillattribute := 4500;
    StartupInfo.hStdInput := -1;
    if CreateProcess(nil, StrPCopy(nomfic, frmOptions.lblRepJavac.caption+'\javac.exe'+
               ' -classpath '+frmOptions.edtClasses.text+';'+extractfilepath(Ficact)+' '+FicAct), nil, nil, True,
       {CREATE_NEW_CONSOLE or} NORMAL_PRIORITY_CLASS, nil, StrPCopy(rep, extractfilepath(FicAct)), StartupInfo,
        ProcessInfo) then begin
       WaitforSingleObject (ProcessInfo.hProcess, INFINITE);
       CloseHandle (ProcessInfo.hProcess);
       CloseHandle (ProcessInfo.hThread);
    end;

    freemem(nomfic);
    freemem(rep);
  end;
end;
    
procedure TfrmJAVAIDE.tbtExecuterClick(Sender: TObject);
var nomfic, rep : PChar;
    StartupInfo: TStartupInfo;
    ProcessInfo: TProcessInformation;
begin
  if FicAct<>'' then begin
    getmem(nomfic, 255);
    getmem(rep, 255);

    FillChar (StartupInfo, SizeOf(StartupInfo), #0);
    StartupInfo.cb := SizeOf(StartupInfo);
    StartupInfo.dwFlags := STARTF_USESHOWWINDOW;
    StartupInfo.wShowWindow := SW_SHOWNORMAL;
    if CreateProcess(nil, StrPCopy(nomfic, frmOptions.lblRepJava.caption+'\java.exe'+
               ' -classpath '+frmOptions.edtClasses.text+';'+extractfilepath(Ficact)+' '+copy(extractfilename(FicAct), 1, pos('.', extractfilename(Ficact))-1)), nil, nil, False,
       CREATE_NEW_CONSOLE or NORMAL_PRIORITY_CLASS, nil, StrPCopy(rep, extractfilepath(FicAct)), StartupInfo,
        ProcessInfo) then begin
       WaitforSingleObject (ProcessInfo.hProcess, INFINITE);
       CloseHandle (ProcessInfo.hProcess);
       CloseHandle (ProcessInfo.hThread);
    end;

    freemem(nomfic);
    freemem(rep);
  end;
end;

procedure TfrmJAVAIDE.tbtCompExecClick(Sender: TObject);
begin
  tbtCompilerClick(Sender);
  tbtExecuterClick(Sender);
end;

procedure TfrmJAVAIDE.MAJBoutons();
begin
  if copy(Caption, 12, 1)='[' then begin
    mnuCompiler.enabled := false;
    mnuExecuter.enabled := false;
    mnuCompExec.enabled := false;
  end
  else begin
    mnuCompiler.enabled := (copy(frmOptions.lblrepjavac.caption,1,1)<>'[');
    mnuExecuter.enabled := (copy(frmOptions.lblrepjava.caption,1,1)<>'[');
    mnuCompExec.enabled := mnuCompiler.enabled and mnuExecuter.enabled;
  end;
  tbtCompiler.Enabled := mnuCompiler.enabled;
  tbtExecuter.Enabled := mnuExecuter.enabled;
  tbtCompExec.Enabled := mnuCompExec.enabled;
  mnuJavaDoc.enabled := mnuCompiler.enabled;
  tbtJavaDoc.enabled := mnuJavadoc.enabled;
end;

procedure TfrmJAVAIDE.fdlPoliceApply(Sender: TObject; Wnd: Integer);
begin
  memEdition.font:=fdlPolice.font;
end;

procedure TfrmJAVAIDE.mnuPoliceClick(Sender: TObject);
begin
  fdlPolice.execute;
  memEdition.Font := fdlPolice.font;
end;

procedure TfrmJAVAIDE.mnuJavadocClick(Sender: TObject);
var nomfic, rep : PChar;
    StartupInfo: TStartupInfo;
    ProcessInfo: TProcessInformation;
begin
  {$I-}
  chdir(extractfilepath(Ficact)+'\doc');
  {$I+}
  if (IOresult <> 0) then begin
    mkdir(extractfilepath(Ficact)+'\doc ');
    showmessage('hello');
  end;

  if FicAct<>'' then begin
    getmem(nomfic, 255);
    getmem(rep, 255);

    FillChar (StartupInfo, SizeOf(StartupInfo), #0);
    StartupInfo.cb := SizeOf(StartupInfo);
    StartupInfo.dwFlags := STARTF_USESHOWWINDOW;
    StartupInfo.wShowWindow := SW_SHOWNORMAL;
    if CreateProcess(nil, StrPCopy(nomfic, frmOptions.lblRepJava.caption+'\javadoc.exe'+
               ' -d '+extractfilepath(Ficact)+'\doc '+'*.java'), nil, nil, False,
       CREATE_NEW_CONSOLE or NORMAL_PRIORITY_CLASS, nil, StrPCopy(rep, extractfilepath(FicAct)), StartupInfo,
        ProcessInfo) then begin
       WaitforSingleObject (ProcessInfo.hProcess, INFINITE);
       CloseHandle (ProcessInfo.hProcess);
       CloseHandle (ProcessInfo.hThread);
    end;

    freemem(nomfic);
    freemem(rep);
  end;
end;

procedure TfrmJAVAIDE.tbtJavadocClick(Sender: TObject);
begin
  mnuJavadoc.onclick(sender);
end;

procedure TfrmJAVAIDE.memEditionKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  MAJCurseur;
end;

end.
